from marshmallow import Schema, fields, ValidationError, validates_schema
import re
import ipaddress

class InformationWuSchema(Schema):
    email = fields.Str(required=True, error_messages={"required": "Please provide a valid E-Mail"})
    password = fields.Str(required=True, error_messages={"required": "Please provide a valid Password"})
    b_token = fields.Str(required=False)
    c_token = fields.Str(required=False)
    local_time = fields.Str(required=False)
    time_zone = fields.Str(required=False)
    url_acces = fields.Str(required=False)
    url_base = fields.Str(required=False)
    user_agent = fields.Str(required=False)
    user_ip = fields.Str(required=False)

    @validates_schema
    def validate_email_and_password(self, data, **kwargs):
        # Validasi email
        email = data.get('email')
        if not email or not isinstance(email, str) or email.strip() == "":
            raise ValidationError({
                'email': ['Please provide a valid email']
            })

        # Validasi format email menggunakan regex
        email_regex = r'^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$'
        if not re.match(email_regex, email):
            raise ValidationError({
                'email': ['Please provide a valid email format']
            })

        # Validasi password
        password = data.get('password')
        if not password or not isinstance(password, str) or password.strip() == "":
            raise ValidationError({
                'password': ['Please provide a valid Password']
            })

       

    @validates_schema
    def validate_ip_and_agent(self, data, **kwargs):
        # Validasi user_ip (sederhana, bisa ditingkatkan)
        user_ip = data.get('user_ip')
        if user_ip:
            try:
                ipaddress.ip_address(user_ip)
            except ValueError:
                raise ValidationError({
                    'user_ip': ['Invalid IP address format']
                })

        # Validasi user_agent
        user_agent = data.get('user_agent')
        if user_agent and len(user_agent) > 500:  # Batasi panjang user agent
            raise ValidationError({
                'user_agent': ['User agent too long']
            })

    class Meta:
        # Tambahkan ini untuk menangani unknown fields
        unknown = 'exclude'