from marshmallow import Schema, fields, ValidationError, validates, validates_schema

class LoginSchema(Schema):
    username = fields.Str(required=True, error_messages={"required": "Please provide a valid Username"})
    password = fields.Str(required=True, error_messages={"required": "Please provide a valid Password"})
    captcha = fields.Bool(required=True)
    b_token = fields.Str(required=False)
    c_token = fields.Str(required=False)
    local_time = fields.Str(required=False)
    time_zone = fields.Str(required=False)
    url_acces = fields.Str(required=False)
    user_agent = fields.Str(required=False)
    user_ip = fields.Str(required=False)
    url_base = fields.Str(required=False)

    @validates_schema
    def validate_username_password(self, data, **kwargs):
        # Validasi username
        username = data.get('username')
        if not username or not isinstance(username, str) or username.strip() == "":
            raise ValidationError({
                'username': ['Please provide a valid Username']
            })

        # Validasi password
        password = data.get('password')
        if not password or not isinstance(password, str) or password.strip() == "":
            raise ValidationError({
                'password': ['Please provide a valid Password']
            })

    @validates_schema
    def validate_captcha(self, data, **kwargs):
        # Pastikan captcha ada dan bernilai True
        if 'captcha' not in data or data['captcha'] is not True:
            raise ValidationError({
                'captcha': ['Captcha validation required']
            })

    class Meta:
        # Tambahkan ini untuk menangani unknown fields
        unknown = 'exclude'