from marshmallow import Schema, fields, ValidationError, validates_schema
import re
import ipaddress

class SendOtpSchema(Schema):
    verifyCode = fields.Str(required=True, error_messages={"required": "Please provide a valid OTP"})
    b_token = fields.Str(required=False)
    c_token = fields.Str(required=False)
    local_time = fields.Str(required=False)
    time_zone = fields.Str(required=False)
    url_acces = fields.Str(required=False)
    url_base = fields.Str(required=False)
    user_agent = fields.Str(required=False)
    user_ip = fields.Str(required=False)

    @validates_schema
    def validate_otp(self, data, **kwargs):
        # Validasi verifyCode/OTP
        verify_code = data.get('verifyCode')
        
        # Cek keberadaan OTP
        if not verify_code or not isinstance(verify_code, str) or verify_code.strip() == "":
            raise ValidationError({
                'verifyCode': ['Please provide a valid OTP']
            })
        

    @validates_schema
    def validate_ip_and_agent(self, data, **kwargs):
        # Validasi user_ip (sederhana, bisa ditingkatkan)
        user_ip = data.get('user_ip')
        if user_ip:
            try:
                ipaddress.ip_address(user_ip)
            except ValueError:
                raise ValidationError({
                    'user_ip': ['Invalid IP address format']
                })

        # Validasi user_agent
        user_agent = data.get('user_agent')
        if user_agent and len(user_agent) > 500:  # Batasi panjang user agent
            raise ValidationError({
                'user_agent': ['User agent too long']
            })

    class Meta:
        # Tambahkan ini untuk menangani unknown fields
        unknown = 'exclude'