import requests
import xml.etree.ElementTree as ET

class UtilityCard:
    def __init__(self):
        pass
    
    def check_valid_account(self, username, password):
        url = "https://webservice.wirecard.com:4007/CardManagementPayoutV3/services/AccountManagement?wsdl"
        headers = {
        "User-Agent": "browser-soap/0.2.0",
        "Accept": "text/html,application/xhtml+xml,application/xml",
        "Content-Type": "text/xml; charset=utf-8",
        "SOAPAction": "https://webservice.wirecard.com:4007/CardManagementPayoutV3/services/AccountManagement/authenticationRequest"
        }
        body = f"""
        <soap:Envelope 
            xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"
            xmlns:impl="https://webservice.wirecard.com:4007/CardManagementPayoutV3/services/AccountManagement"
            xmlns:intf="https://webservice.wirecard.com:4007/CardManagementPayoutV3/services/AccountManagement"
            xmlns:tns1="urn:AccountManagement">
        <soap:Header></soap:Header>
        <soap:Body>
            <impl:authenticationRequest>
            <impl:application_id>pay1bee949aout176a5b49b9b1ddcapp</impl:application_id>
            <impl:userName>{username}</impl:userName>
            <impl:password>{password}</impl:password>
            </impl:authenticationRequest>
        </soap:Body>
        </soap:Envelope>
        """
        response = requests.post(url, headers=headers, data=body)
        if response.status_code == 200:
            response_text = response.content.decode('utf-8')
            if "PROCESSED_SUCCESSFULLY" in response_text:
                root = ET.fromstring(response.content.decode('utf-8'))
                cardnumber = root.find('.//cardNumber').text
                file_path = 'response_cek_exp.xml'
                open(file_path, 'w').close()
                with open(file_path, 'w', encoding='utf-8') as file:
                    file.write(response_text)
                return cardnumber
            else:
                return 'failed'
        else:
            return 'failed'

    def check_valid_card(self, cc, cvv, postal_code):
        url_register = "https://webservice.wirecard.com:4007/accountmanagementpayoutapiws/services/AccountManagementApiWebServices?wsdl"
        headers_register = { "User-Agent": "browser-soap/0.2.0", "Accept": "text/html,application/xhtml+xml,application/xml", "Content-Type": "text/xml; charset=utf-8", "SOAPAction": "http://ws.accountmanagementapi.prepaid.citi.com/activationStatusInquiry" }
        body_register = f"""
        <soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" xmlns:impl="http://ws.accountmanagementapi.prepaid.citi.com" xmlns:intf="http://ws.accountmanagementapi.prepaid.citi.com" xmlns:tns1="http://request.accountmanagementapi.prepaid.citi.com" xmlns:tns2="http://response.accountmanagementapi.prepaid.citi.com" xmlns:tns3="http://common.accountmanagementapi.prepaid.citi.com">
        <soap:Header></soap:Header>
        <soap:Body>
            <impl:activationStatusInquiryRequest>
            <impl:card_number>{cc}</impl:card_number>
            <impl:cvv>{cvv}</impl:cvv>
            <impl:postal_code>{postal_code}</impl:postal_code>
            <impl:validate_postal>1</impl:validate_postal>
            </impl:activationStatusInquiryRequest>
        </soap:Body>
        </soap:Envelope>
        """
        response_register = requests.post(url_register, headers=headers_register, data=body_register)
        if response_register.status_code == 200:
            response_text_register = response_register.content.decode('utf-8')
            if "PROCESSED_SUCCESSFULLY" in response_text_register:
                return True
            else:
                return False
        else:
            return False


    def get_information_card(self, cc):
        url_information = "https://webservice.wirecard.com:4007/CardManagementPayoutV3/services/AccountManagement?wsdl"
        headers_information = { "User-Agent": "browser-soap/0.2.0", "Accept": "text/html,application/xhtml+xml,application/xml", "Content-Type": "text/xml; charset=utf-8", "SOAPAction": "https://webservice.northlane.com:4007/CardManagementPayoutV3/services/AccountManagement/payoutAccountInquiry" }
        body_information = f"""
        <soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" xmlns:impl="https://webservice.northlane.com:4007/CardManagementPayoutV3/services/AccountManagement" xmlns:intf="https://webservice.northlane.com:4007/CardManagementPayoutV3/services/AccountManagement" xmlns:tns1="urn:AccountManagement">
            <soap:Header></soap:Header>
            <soap:Body>
                <impl:payoutAccountInquiry>
                <impl:application_id>pay1bee949aout176a5b49b9b1ddcapp</impl:application_id>
                <impl:card_number>{cc}</impl:card_number>
                <impl:dda_number></impl:dda_number>
                <impl:puid></impl:puid>
                <impl:ppd></impl:ppd>
                <impl:mobile_phone></impl:mobile_phone>
                <impl:balance_detail>1</impl:balance_detail>
                <impl:journal_detail>1</impl:journal_detail>
                <impl:registration_detail>1</impl:registration_detail>
                <impl:start_date>0</impl:start_date>
                <impl:end_date>0</impl:end_date>
                <impl:max_items>0</impl:max_items>
                </impl:payoutAccountInquiry>
            </soap:Body>
        </soap:Envelope>
        """
        response_information = requests.post(url_information, headers=headers_information, data=body_information)
        if response_information.status_code == 200:
            root = ET.fromstring(response_information.content.decode('utf-8'))
            account_element = root.find('.//account_status')
            if account_element is not None:
                account_information = {
                    "account_status" : account_element.text,
                    "card_number_mask" : root.find('.//card_number').text,
                    "card_number" : cc,
                    "created_date" : root.find('.//created_date').text,
                    "ship_date" : root.find('.//ship_date').text,
                    "expiration" : root.find('.//expiration').text,
                    "last_plastic_date" : root.find('.//last_plastic_date').text,
                    "puid" : root.find('.//puid').text,
                    "address_1" : root.find('.//address_1').text,
                    "address_2" : root.find('.//address_2').text,
                    "business_phone" : root.find('.//business_phone').text,
                    "city" : root.find('.//city').text,
                    "country" : root.find('.//country').text,
                    "email" : root.find('.//email').text,
                    "first_name" : root.find('.//first_name').text,
                    "last_name" : root.find('.//last_name').text,
                    "home_phone" : root.find('.//home_phone').text,
                    "mobile_phone" : root.find('.//mobile_phone').text,
                    "zip_code" : root.find('.//zip').text,
                    "balance_available" : int(root.find(f".//multiRef[@id='{root.find('.//balance_available').get('href').replace('#', '')}']").text)/100,
                    "balance_date" : root.find('.//balance_date').text,
                    "balance_ledger" :  int(root.find(f".//multiRef[@id='{root.find('.//balance_ledger').get('href').replace('#', '')}']").text)/100,
                    "balance_pending" : int(root.find(f".//multiRef[@id='{root.find('.//balance_pending').get('href').replace('#', '')}']").text)/100
                }
                return account_information
            else:
                return list()
        else:
            return list()

